<?php

namespace Adfox\ECommerce\Models;

use Adfox\ECommerce\Models\Inventory;
use Adfox\ECommerce\Models\ReturnPolicy;
use Adfox\ECommerce\Models\StockTransaction;
use Adfox\ECommerce\Models\Warehouse;
use App\Foundation\AdBase\Models\BaseAdModel;
use App\Models\CustomerReview;

class Product extends BaseAdModel
{
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Conditionally add fields based on the plugin
        $this->fillable = array_merge($this->fillable, [
            'stock_quantity',
            'sku',
            'return_policy_id',
            'enable_cash_on_delivery',
        ]);
    }

    public function returnPolicy()
    {
        return $this->belongsTo(ReturnPolicy::class, 'return_policy_id', 'id');
    }

    public function inventories()
    {
        return $this->hasMany(Inventory::class, 'ad_id', 'id');
    }

    public function warehouse()
    {
        return $this->hasMany(Warehouse::class, 'ad_id', 'id');
    }

    public function stock_transactions()
    {
        return $this->hasMany(StockTransaction::class, 'ad_id', 'id');
    }

    public function customerReviews()
    {
        return $this->morphMany(CustomerReview::class, 'reviewable');
    }
}
