<?php

namespace Adfox\Feedback\Filament\App\Pages;

use App\Settings\FeedbackSettings;
use Filament\Pages\Page;
use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;
use Illuminate\Support\Facades\Schema;
use Livewire\Attributes\Url;
class MyFeedback extends Page
{
    protected static ?int $navigationSort = 4;
    protected static string $view = 'feedback::filament.app.pages.my-feedback';
    use SEOToolsTrait;

    public $activeTab = 'sent';

    #[Url(as: 'ref', keep: true)]
    public $referrer = '/';

    public static function getNavigationGroup(): ?string
    {
        return __('messages.t_insights_navigation');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_my_feedback');
    }
    public  function getTitle(): string
    {
        return __('messages.t_my_feedback');
    }
    /**
     * Initializes the component.
     */
    public function mount()
    {
        $this->setSeoData();

    }


    public function setActiveTab($tabName)
    {
        $this->activeTab = $tabName;
        $this->dispatch('fetch-feedback');
    }

    /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_my_feedback') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }

    public static function isDiscovered(): bool
    {
        return (app('filament')->hasPlugin('feedback') && (Schema::hasTable('settings') && app(FeedbackSettings::class)->enable_feedback));
    }

}
