<?php

namespace Adfox\Feedback\Filament\Pages;

use App\Filament\Clusters\FeedbackManagement;
use App\Settings\FeedbackSettings;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class ManageFeedbackSettings extends SettingsPage
{
    use HasPageShield;

    protected static ?string $navigationIcon = 'heroicon-o-cog';

    protected static ?string $cluster = FeedbackManagement::class;

    protected static ?string $slug = 'manage-feedback-settings';

    protected static string $settings = FeedbackSettings::class;

    protected static ?int $navigationSort = 13;

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageFeedbackSettings');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_feedback_configuration');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_feedback_settings');
    }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_feedback')
                ->label(__('messages.t_ap_enable_feedback'))
                ->helperText(__('messages.t_ap_enable_feedback_helper')),

            Toggle::make('enable_replies')
                ->label(__('messages.t_ap_enable_replies'))
                ->helperText(__('messages.t_ap_enable_replies_helper')),

            Toggle::make('enable_likes')
                ->label(__('messages.t_ap_enable_likes'))
                ->helperText(__('messages.t_ap_enable_likes_helper')),

            ])
            ->columns(2);
    }
}
