<?php

namespace Adfox\Flutterwave;

use Filament\Panel;
use Filament\Contracts\Plugin;

class FlutterwavePlugin implements Plugin
{
    public function getId(): string
    {
        return 'flutterwave';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Flutterwave\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Flutterwave\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
