<?php

namespace Adfox\Flutterwave\Http\Controllers\Callback;


use App\Http\Controllers\Controller;
use App\Models\{WebhookUpgrade,  WebhookPackage};
use Illuminate\Http\Request;
use App\Settings\FlutterwaveSettings;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Traits\HandlesPromotionApplication;
use App\Traits\HandlesPackageApplication;

class FlutterwaveController extends Controller
{
    private $flutterwaveSettings;
    use HandlesPackageApplication;
    use HandlesPromotionApplication;
    /**
     * Handle the callback from the Stripe payment gateway.
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function callback(Request $request)
    {
        $this->flutterwaveSettings = app(FlutterwaveSettings::class);


         // Get transaction id
         $transaction_id = $request->get('transaction_id');

         // Check webhook event
         if ($transaction_id) {

            $response = $this->verifyPayment($transaction_id);

            if ( is_array($response) && $response['success'] == TRUE) {

                // Get order id
                $order_id = $response['response']['data']['tx_ref'];

                // Check If Package Management Callback
                if (Str::startsWith($order_id, "PKG-")) {

                    $orderData = WebhookPackage::where('payment_id', $order_id)
                    ->where('payment_method', 'flutterwave')
                    ->where('status', 'pending')
                    ->firstOrFail();

                    $routeParameters = $this->applyPackages($orderData);

                    return redirect()->route('package-success', $routeParameters);

                } else {

                    $orderData = WebhookUpgrade::where('payment_id', $order_id)
                                            ->where('payment_method', 'flutterwave')
                                            ->where('status', 'pending')
                                            ->firstOrFail();

                    $routeParameters = $this->applyPromotionsWithRedirect($orderData);

                    return redirect()->route('success-upgrade', $routeParameters);
                }
            }
        }

        return redirect('/');
    }


     /**
     * Verify if payment succeeded
     *
     * @param string $id
     * @return array
     */
    private function verifyPayment($id)
    {
        try {

            // Get payment gateway keys
            $secret_key = $this->flutterwaveSettings->secret_key;

            $response   = Http::withHeaders([
                                    'Authorization' => 'Bearer ' . $secret_key,
                                    'Accept'        => 'application/json',
                                ])->get("https://api.flutterwave.com/v3/transactions/$id/verify")->json();


            // Check if payment succeeded
            if ( is_array($response) && $response['status'] === 'success' ) {

                // Done
                return [
                    'success'  => true,
                    'response' => $response
                ];

            } else {

                // Failed
                return [
                    'success' => false,
                    'message' => __('messages.t_error_payment_failed')
                ];

            }

        } catch (\Throwable $th) {

            // Error
            return [
                'success' => false,
                'message' => __('messages.t_toast_something_went_wrong')
            ];

        }
    }

}

