<?php
namespace Adfox\LoginOtp\Livewire;

use App\Models\MobileVerificationCode;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;
use Livewire\Component;

class VerificationOtp extends Component
{


    #[Url(keep: true)]
    public $userId;
    public $otp;

    /**
     * mount
     *
     * @return void
     */
    public function mount()
    {
        if (auth()->user()->hasVerifiedEmail()) {
            return redirect()->intended(RouteServiceProvider::HOME);
        }
        // check if a user exists
        $user = User::whereId($this->userId)->firstOrFail();
    }

    /**
     * this function check if OTP is correct and it's expired or not.if otp is valid user can login
     *
     * @return mixed return otp status or if it's valid return to home page
     */
    public function loginWithOtp()
    {
        $this->validate([
            'otp' => 'required'
        ]);
        //  Validation Logic
        $verificationCode   = MobileVerificationCode::where('user_id', $this->userId)->where('otp', $this->otp)->first();
        $now = Carbon::now();

        //check verification code exists
        if (!$verificationCode) {
            return  session()->flash('status', 'otp-incorrect');
        }
        //check otp has expired or not
        elseif ($verificationCode && $now->isAfter($verificationCode->expire_at)) {
            return  session()->flash('status', 'otp-expired');
        }

        $user = User::whereId($this->userId)->first();

        if ($user) {
            // Expire The OTP
            $verificationCode->update([
                'expire_at' => Carbon::now()
            ]);
            $user->markEmailAsVerified();

            return redirect('/');
        }
    }

    // this function call when user click resend otp
    #[On('resend-otp')]
    public function resendOtp()
    {

        $user = User::whereId($this->userId)->first();
        // create sendotp object
        $sendOtp = new VerificationSendOtp;
        //call send otp method
        $sendOtp->sendOtp($user->phone_number,'resend');

    }

    public function render()
    {
        return view('login-otp::verification-otp')->extends('login-otp::layouts.auth')->section('content');
    }

}
