@props(['item', 'selectedItems'])

<div role="button" wire:click="toggleSelection({{ $item->id }})" class="bg-white flex gap-x-2 ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 px-3 py-4 rounded-xl mb-6 cursor-pointer classic:ring-black">
    <div>
        @if(in_array($item->id, $selectedItems))
            <x-heroicon-s-check-circle class="w-8 h-8 text-success-600" />
        @else
            <div  class="w-8 h-8 flex items-center justify-center">
            <span class="w-6 h-6 text-gray-900 rounded-full border border-black block" ></span>
            </div>
        @endif
    </div>
    <div>
        <p class="font-semibold text-lg">{{ $item->name }}</p>
        <p>{{ __('messages.t_available') }}: {{ $item->available }}</p>
        <p>{{ __('messages.t_package_expires_in') }} {{ \Carbon\Carbon::parse($item->expiry_date)->diffInDays(now()) }} {{ __('messages.t_days') }}</p>
    </div>
</div>
