<div>
    @php
        $title = '';
        $message = '';

        switch ($actionType) {
            case 'package-purchase':
                $title = __('messages.t_package_purchase_success');
                $message = __('messages.t_package_purchase_message');
                break;

            case 'ad-upgrade':
                $title = __('messages.t_ad_upgrade_success');
                $message = __('messages.t_ad_upgrade_message');
                break;

            case 'apply-package':
                $title = __('messages.t_apply_package_success');
                $message = __('messages.t_apply_package_message');
                break;

            default:
                $title = __('messages.t_general_success');
                $message = __('messages.t_general_success_message');
                break;
        }
    @endphp

    <livewire:layout.header lazy />

    <div class="flex flex-col items-center justify-center min-h-screen md:min-h-full md:mt-20">
        <!-- Success Image -->
        <img src="{{ asset('/images/tick.svg') }}" alt="success" class="w-16 h-16 mb-4">

        <!-- Congratulations Text -->
        <h2 class="text-xl mb-2 font-semibold">{{ $title }}</h2>

        <p class="text-center mb-6">{{ $message }}</p>

        <div class="flex justify-center gap-x-4">
            @if($ad)
                <x-filament::button
                    href="{{ route('ad.overview', ['slug' => $ad->slug ]) }}"
                    tag="a"
                    outlined
                >
                {{ __('messages.t_preview_ad') }}
                </x-filament::button>
            @endif

            @if($actionType == 'package-purchase' && Route::has('filament.app.pages.my-packages'))
            <x-filament::button
                href="{{ route('filament.app.pages.my-packages') }}"
                tag="a"
                outlined
            >
                {{ __('messages.t_my_packages') }}
            </x-filament::button>
            @endif

            <x-filament::button
                href="{{ route('home') }}"
                tag="a"
                color="gray"
            >
            {{ __('messages.t_back_to_home') }}
            </x-filament::button>

        </div>
    </div>
    <livewire:layout.sidebar  />
</div>

