<?php

namespace Adfox\Packages\Filament\App\Pages;

use Filament\Pages\Page;
use App\Models\OrderPackageItem;
use App\Settings\PackageSettings;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Grouping\Group;
use Illuminate\Support\Facades\Schema;

class MyPackages extends Page implements HasTable
{
    use InteractsWithTable;

    protected static string $view = 'packages::filament.app.pages.my-packages';
    protected static ?int $navigationSort = 1;

    public static function getNavigationGroup(): ?string
    {
        return __('messages.t_engagements_navigation');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_my_packages');
    }

    public function getTitle(): string
    {
        return __('messages.t_my_packages');
    }

    public function mount() {}

    public function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            // ->emptyStateIcon('/images/not-found.svg')
            ->emptyState(view('tables.empty-state', ['message' => __('messages.t_no_order_packages')]))
            ->query(OrderPackageItem::query()->whereHas('orderPackage', fn($query) => $query->where('user_id', auth()->id())))
            ->groups([
                Group::make('orderPackage.id')
                    ->label(__('messages.t_order_id'))
                    ->getDescriptionFromRecordUsing(fn(OrderPackageItem $record): string => $this->getOrderDescription($record))
            ])
            ->defaultGroup('orderPackage.id')
            ->columns($this->getTableColumns())
            ->filters([]);
    }

    protected function getOrderDescription(OrderPackageItem $record): string
    {
        $paymentMethod = $record->orderPackage->payment_method === 'offline'
            ? __('messages.t_offline')
            : getPaymentLabel($record->orderPackage->payment_method);

        return __('messages.t_payment_method') . ': ' . $paymentMethod .
            ', ' . __('messages.t_taxes') . ': ' . $record->orderPackage->taxes_value .
            ', ' . __('messages.t_subtotal') . ': ' . $record->orderPackage->subtotal_value .
            ', ' . __('messages.t_total') . ': ' . $record->orderPackage->total_value;
    }

    protected function getTableColumns(): array
    {
        return [
            TextColumn::make('name')
                ->label(__('messages.t_package_name'))
                ->formatStateUsing(fn($record) => $record?->packageItem?->promotion ? $record->packageItem->promotion->promotion->name : __('messages.t_extra_ad_postings')),
            TextColumn::make('activation_date')->label(__('messages.t_activation_date'))->date('d/m/Y'),
            TextColumn::make('expiry_date')->label(__('messages.t_expiry_date'))->date('d/m/Y'),
            TextColumn::make('purchased')->label(__('messages.t_purchased')),
            TextColumn::make('available')->label(__('messages.t_available')),
            TextColumn::make('used')->label(__('messages.t_used')),
        ];
    }

    public static function isDiscovered(): bool
    {
        return app('filament')->hasPlugin('packages') &&
            Schema::hasTable('settings') &&
            app(PackageSettings::class)->status;
    }
}
