<?php

namespace Adfox\Paymongo\Http\Controllers\Callback;


use App\Http\Controllers\Controller;
use App\Models\{WebhookUpgrade,  WebhookPackage};
use Illuminate\Http\Request;
use App\Settings\FlutterwaveSettings;
use App\Settings\PaymongoSettings;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Traits\HandlesPromotionApplication;
use App\Traits\HandlesPackageApplication;
use Illuminate\Contracts\Session\Session;

class PaymongoController extends Controller
{
    private $paymongoSettings;
    use HandlesPackageApplication;
    use HandlesPromotionApplication;
    /**
     * Handle the callback from the Stripe payment gateway.
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function callback(Request $request)
    {
        $this->paymongoSettings = app(PaymongoSettings::class);

         // Get transaction id
         $transaction_id = session('paymongo_checkout_id');

         // Check webhook event
         if ($transaction_id) {

            $response = $this->verifyPayment($transaction_id);

            if ( is_array($response) && $response['success'] == TRUE) {
                // Get order id
                $order_id = $response['response']['attributes']['reference_number'];
               
                // Check If Package Management Callback
                if (Str::startsWith($order_id, "PKG-")) {

                    $orderData = WebhookPackage::where('payment_id', $order_id)
                    ->where('payment_method', 'paymongo')
                    ->where('status', 'pending')
                    ->firstOrFail();

                    $routeParameters = $this->applyPackages($orderData);

                    return redirect()->route('package-success', $routeParameters);

                } else {

                    $orderData = WebhookUpgrade::where('payment_id', $order_id)
                                            ->where('payment_method', 'paymongo')
                                            ->where('status', 'pending')
                                            ->firstOrFail();

                    $routeParameters = $this->applyPromotionsWithRedirect($orderData);

                    return redirect()->route('success-upgrade', $routeParameters);
                }
            }
        }
        // dd($response);

        return redirect('/');
    }


     /**
     * Verify if payment succeeded
     *
     * @param string $id
     * @return array
     */
    private function verifyPayment($id)
    {
        try {
            $client = new \GuzzleHttp\Client();
            // Get payment gateway keys
            $response = $client->request('GET', 'https://api.paymongo.com/v1/checkout_sessions/'.$id, [
                'headers' => [
                  'accept' => 'application/json',
                  'authorization' => 'Basic c2tfdGVzdF9RdkdTb01BWjhFUkduNEtxOHlkM1FiSjI6',
                ],
              ]);
              $data = json_decode($response->getBody(), true);

           $returnResponse=$data['data']['attributes']['payments'][0]['attributes']['status'];

            // Check if payment succeeded
            if (  $returnResponse === 'paid' ) {
                // Done
                return [
                    'success'  => true,
                    'response' => $data['data']
                ];

            } else {

                // Failed
                return [
                    'success' => false,
                    'message' => __('messages.t_error_payment_failed')
                ];

            }

        } catch (\Throwable $th) {

            // Error
            return [
                'success' => false,
                'message' => __('messages.t_toast_something_went_wrong')
            ];

        }
    }

}

