<?php

namespace Adfox\Paypal;

use Filament\Panel;
use Filament\Contracts\Plugin;

class PaypalPlugin implements Plugin
{
    public function getId(): string
    {
        return 'paypal';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Paypal\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Paypal\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
