<?php

namespace Adfox\Payu\Providers;

use Adfox\Payu\Livewire\PayuPayment;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\Payu\PayuPlugin;
use Livewire\Livewire;

class PayuServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new PayuPlugin()));
    }

    public function boot()
    {
        Relation::morphMap([]);
        Livewire::component('payu-payment', PayuPayment::class);
    }
}
