<?php

namespace Adfox\Phonepe;

use Filament\Panel;
use Filament\Contracts\Plugin;

class PhonepePlugin implements Plugin
{
    public function getId(): string
    {
        return 'phonepe';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Phonepe\\Filament\\Resources'
            )->discoverPages(
                in: __DIR__ . '/Filament/Pages',
                for: 'Adfox\\Phonepe\\Filament\\Pages'
            );
        }
    }

    public function boot(Panel $panel): void {}
}
