<?php

namespace Adfox\Subscription\Console\Commands;

use App\Models\Ad;
use App\Models\Plan;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;

class DeleteExpiredFreeAds extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscription:delete-expired-free-ads';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete free ads after their expiration period based on the plans.';

    /**
     * Delete expired free ads.
     */
    public function handle()
    {

        // Get free ads
        $freeAds = Ad::source('free')->get();
        foreach ($freeAds as $ad) {
            //Get user current plan
            $plan = getUserSubscriptionPlan($ad->user_id);
            //Check if plan is free and delete free ads is enabled
            if ($plan->is_free && $plan->delete_free_ads) {
                $freeListingDurationDays = $plan->free_listing_duration_days;
                //Calculate expired date
                $expiredDate=Carbon::create($ad->posted_date)->addDays($freeListingDurationDays);
                //Delete ad if expired
                if($expiredDate->lte(Carbon::now())){
                    $ad->status='draft';
                    $ad->save();
                    $ad->delete();
                }
            }
        }
    }
}
