<?php

namespace Adfox\Subscription\Console\Commands;

use App\Models\Subscription;
use Carbon\Carbon;
use Illuminate\Console\Command;

class DisabledExpiredPromotionAds extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscription:disabled-expired-promotions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

  /**
   * Disable promotion for expired subscription
   *
   * @return void
   */
    public function handle()
    {
        $expiredSubscriptions=Subscription::inactive()->whereDate('ends_at','<',today())->with('adPromotions')->get();
        foreach($expiredSubscriptions as $subscription){
            foreach($subscription->adPromotions as $adPromotion){
                   $adPromotion->update([
                        'active' => 'false',
                   ]);
                }
        }
    }
}
