<?php

namespace Adfox\Subscription\Filament\Resources\SubscriptionResource\Pages;

use Adfox\Subscription\Filament\Resources\SubscriptionResource;
use App\Models\Plan;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;

class ListSubscriptions extends ListRecords
{
    protected static string $resource = SubscriptionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make()
            ->using(function (array $data, string $model) {
                $plan=Plan::find($data['plan_id']);
                $user=User::find($data['user_id']);
                $data['ad_count']=$plan->ad_count;
                $data['feature_ad_count']=$plan->feature_ad_count;
                $data['urgent_ad_count']=$plan->urgent_ad_count;
                $data['spotlight_ad_count']=$plan->spotlight_ad_count;
                $data['website_url_count']=$plan->website_url_count;
                $data['is_admin_granted']=true;
                $data['starts_at']=now();
                return $user->subscriptions()->create($data);
            }),
        ];
    }
}
