<?php

namespace Adfox\Subscription\Filament\Resources\SubscriptionResource\Pages;

use Adfox\Subscription\Filament\Resources\SubscriptionResource;
use Filament\Actions;
use Filament\Infolists;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;

class ViewSubscription extends ViewRecord
{
    protected static string $resource = SubscriptionResource::class;

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Infolists\Components\TextEntry::make('subscriber.name'),
                Infolists\Components\TextEntry::make('plan.name'),
                Infolists\Components\TextEntry::make('status')
                ->formatStateUsing(fn(string $state): string => __("messages.t_{$state}")),
                Infolists\Components\TextEntry::make('starts_at')
                ->date('d/m/Y'),
                Infolists\Components\TextEntry::make('ends_at')
                ->date('d/m/Y'),
                Infolists\Components\TextEntry::make('cancels_at')
                ->date('d/m/Y'),
            ]);
    }
}
