<?php

namespace Adfox\Subscription\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Settings\StripeSettings;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Log;
use Stripe\StripeClient;

class SubscriptionController extends Controller
{
    public function createSubscription(
        Request $request
    ) {
        $stripe = $this->initializeStripeClient();
        $customer_id = $request->input('customer_id');
        $price_id = $request->input('price_id');
        $user_id = $request->input('user_id');
        $plan_id = $request->input('plan_id');
        $ad_count = $request->input('ad_count');
        $featured_ad_count = $request->input('featured_ad_count');
        $urgent_ad_count = $request->input('urgent_ad_count');
        $spotlight_ad_count = $request->input('spotlight_ad_count');
        $website_url_count = $request->input('website_url_count');
        $coupon_id = $request->input('coupon_id');

        $subscription = $stripe->subscriptions->create
        ([
                'customer' => $customer_id,
                'items' => [
                    [
                        'price' => $price_id,
                    ]
                ],
                'payment_behavior' => 'default_incomplete',
                'payment_settings' => [
                    'save_default_payment_method' => 'on_subscription'
                ],
                'coupon' => $coupon_id,
                'expand' => ['latest_invoice.payment_intent', 'pending_setup_intent'],
                'metadata' => [
                    'user_id' => $user_id,
                    'plan_id' => $plan_id,
                    'ad_count' => $ad_count,
                    'featured_ad_count' => $featured_ad_count,
                    'urgent_ad_count' => $urgent_ad_count,
                    'spotlight_ad_count' => $spotlight_ad_count,
                    'website_url_count' => $website_url_count,
                ]
            ]);

        if ($subscription->pending_setup_intent !== NULL) {
            return response()->json([
                'type' => 'setup',
                'clientSecret' => $subscription->pending_setup_intent->client_secret
            ]);
        } else {
            return response()->json([
                'type' => 'payment',
                'clientSecret' => $subscription->latest_invoice->payment_intent->client_secret
            ]);
        }
    }
    public function initializeStripeClient()
    {
        return new StripeClient(app(StripeSettings::class)?->secret_key);
    }
}
