<?php
namespace Adfox\Subscription\Livewire\Promotion;

use App\Models\PlanFeature;
use App\Models\Ad;
use App\Models\AdPromotion;
use App\Models\Promotion;
use Carbon\Carbon;

use Illuminate\Support\Facades\Session;
use Livewire\Attributes\On;
use Livewire\Component;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Redirect;
use Livewire\Attributes\Url;

class ChoosePromotion extends Component
{

    public $selectedAdSlugs;
    #[Url(as: 'promotion_type', keep: true)]
    public $promotionType;
    #[Url(as: 'id', keep: true)]
    public $id;
    public $promotions = [];
    public $selectedPromotions = [];
    public $availablePlanPromotions = [];
    public $current = 'promotion-details';
    public $steps = [
        'promotion-details',
        'ad.post-ad.payment-ad'
    ];
    public function mount()
    {
        $this->selectedAdSlugs = Session::get('selected-ads');
        if ($this->promotionType == 'apply') {
            $this->loadPlanPromotions();
        }
    }


    public function loadPlanPromotions()
    {
        //Fetch active subscription for the user
        // $plans = auth()->user()->getActiveSubscriptions()->pluck('plan_id');
        // if ($plans->isEmpty()) {
        //     return 0;
        // }
        //Get promotion id with value
        $activeSubscription=getActiveSubscription();
        $promotions = Promotion::all();
            foreach ($promotions as $promotion) {
                $promotionId=$promotion->id;
                $promotionCount=0;
                if($promotionId==1){
                    $promotionCount = getRemaningFeaturedAdCount();
                }
                if($promotionId==2){
                    $promotionCount = getRemaningSpotlightAdCount();
                }
                if($promotionId==3){
                    $promotionCount = getRemaningUrgentAdCount();
                }
                if($promotionId==4){
                    $promotionCount = getRemaningWebsiteUrlAdCount();
                }
                if ($this->isEligibleForUpgrade($this->id, $promotionId) && $promotionCount) {
                    $this->availablePlanPromotions[] = $promotion;
                }
            }
    }


    /**
     * Toggle a promotion's selection status.
     *
     * @param int $promotion->id The ID of the promotion to toggle.
     */
    public function toggleSelection($promotionId)
    {
        if ($this->promotionType === 'apply') {
            // For 'single' type, only allow one item to be selected at a time.
            $this->selectedPromotions = [$promotionId];
        } else {
            // For other types, allow multiple selections.
            if (in_array($promotionId, $this->selectedPromotions)) {
                // If the item is already selected, deselect it.
                $this->selectedPromotions = array_diff($this->selectedPromotions, [$promotionId]);
            } else {
                // If the item is not selected, add it to the selection.
                $this->selectedPromotions[] = $promotionId;
            }
        }
        $this->dispatch('promotion-selected', $this->selectedPromotions);
    }

    #[On('proceed-payment')]
    public function proceedPayment()
    {

        if (count($this->selectedPromotions)) {
            if ($this->promotionType == 'multiple') {
                $this->current = 'payment-promotion';
            }
        }
    }

    #[On('apply-promotion')]
    public function applyPromotions()
    {
        foreach ($this->selectedPromotions as $key => $promotionId) {
            $promotion = Promotion::find($promotionId);
            //Find the available subscription for the specified promotion
            $subscription = $this->findAvailableSubscription();
            $subscriptionId = $subscription?->id ?? null;
            $source=$subscriptionId? 'subscription':'free';
            $endDate=$source == 'subscription' ? $subscription?->ends_at:Carbon::now()->addMonth() ;
            // Check if the ad is eligible for the promotion upgrade and if a subscription ID is available
            if ($this->isEligibleForUpgrade($this->id, $promotionId) ) {
                //Create AdPromotion with the given details
                $adPromotion = AdPromotion::create([
                    'ad_id' => $this->id,
                    'promotion_id' => $promotionId,
                    'start_date' => Carbon::now(),
                    'end_date' => $endDate,
                    'source' => 'subscription',
                    'subscription_id' => $subscriptionId,
                ]);
                $routeParameters = ['ad_id' => $this->id];
                return Redirect::route('success-upgrade', $routeParameters);

            } else {
                // if promotion is already active return notification
                Notification::make()
                    ->title(trans('messages.t_already_active', ['promotion' => $promotion->name]))
                    ->danger()
                    ->send();
            }
        }
    }

    /**
     * Calculate the remaining ad promotion count for promotion
     *
     * @param [type] $promotionId
     * @return void $adPromotionCount
     */
    public function getRemainAdPromotionCount($promotionId)
    {
        $user = auth()->user();
        $activeSubscriptions = $user->getActiveSubscriptions();
        $adPromotionCount = 0;
        foreach ($activeSubscriptions as $subscription) {
            $remainAdPromotionCount = $subscription->getRemainAdPromotionCount($promotionId);
            $adPromotionCount += $remainAdPromotionCount;
        }
        return $adPromotionCount;
    }

    /**
     * check if ad is eligible for promotion
     *
     * @param [type] $adId
     * @param [type] $promotionId
     * @return boolean
     */
    public function isEligibleForUpgrade($adId, $promotionId)
    {
        $existingPromotion = AdPromotion::where('ad_id', $adId)
            ->where('promotion_id', $promotionId)
            ->latest()
            ->first();
        if (!$existingPromotion || $existingPromotion->end_date->isPast()) {
            return true;
        }
        return false;
    }
    /**
     * Find available subscription for ad promotion based on the ad promotion availability
     *
     * @param [type] $promotionId
     * @return void
     */
    public function findAvailableSubscription()
    {
        $user = auth()->user();
        //Fetch active subscription for the user
        $activeSubscriptions = $user->getActiveSubscriptions()->first();
        return $activeSubscriptions;
    }

    /**
     * Move to the previous step or redirect to home if at the first step.
     */
    public function redirectBack()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex === 0) {
            // Redirect to home if at the first step
            return redirect(route('filament.app.pages.my-ads'));
        }

        if ($currentIndex !== false && isset($this->steps[$currentIndex - 1])) {
            $this->current = $this->steps[$currentIndex - 1];
        }
    }
    public function render()
    {
        return view('subscription::promotion.choose-promotion');
    }
}
