<?php

namespace Adfox\WalletSystem\Filament\Resources;

use Adfox\WalletSystem\Filament\Resources\BankResource\Pages;
use App\Models\Wallets\Bank;
use App\Filament\Clusters\WalletSystem;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;


class BankResource extends Resource implements HasShieldPermissions
{
    protected static ?string $model = Bank::class;

    protected static ?string $cluster = WalletSystem::class;

    protected static ?string $navigationIcon = 'heroicon-o-building-library';

    public static function getPermissionPrefixes(): array
    {
        return [
            'create',
            'update',
            'view_any',
            'delete_any',
            'delete'
        ];
    }

    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_bank');
    }

    public static function canCreate(): bool
    {
        return userHasPermission('create_bank');
    }

    public static function canEdit($record): bool
    {
        return userHasPermission('update_bank');
    }

    public static function canDelete($record): bool
    {
        return userHasPermission('delete_bank');
    }
    public static function canDeleteAny(): bool
    {
        return userHasPermission('delete_any_bank');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('bank_name')
                    ->required()
                    ->label(__('messages.t_bank_name'))
                    ->maxLength(255),

                TextInput::make('bank_code')
                    ->required()
                    ->label(__('messages.t_bank_code'))
                    ->maxLength(10),

                Select::make('country_id')
                    ->required()
                    ->label(__('messages.t_country_id'))
                    ->relationship('country', 'name'),

                Select::make('status')
                    ->required()
                    ->label(__('messages.t_status'))
                    ->options([
                        'active' => __('messages.t_active'),
                        'inactive' => __('messages.t_inactive'),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->columns([
                Tables\Columns\TextColumn::make('bank_name')
                    ->label(__('messages.t_bank_name'))
                    ->sortable(),

                Tables\Columns\TextColumn::make('bank_code')
                    ->label(__('messages.t_bank_code'))
                    ->sortable(),

                Tables\Columns\TextColumn::make('country.name')
                    ->label(__('messages.t_country_id'))
                    ->sortable(),

                Tables\Columns\TextColumn::make('status')
                    ->label(__('messages.t_status'))
                    ->sortable(),
            ])
            ->actions([
                Tables\Actions\EditAction::make()
                    ->label(__('messages.t_edit_bank')),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBanks::route('/'),
            'create' => Pages\CreateBank::route('/create'),
            'edit' => Pages\EditBank::route('/{record}/edit'),
        ];
    }
}
