<?php

namespace Adfox\WalletSystem\Filament\Resources;

use Adfox\WalletSystem\Filament\Resources\EarningResource\Pages;
use App\Models\Wallets\Commission;
use App\Filament\Clusters\WalletSystem;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

class EarningResource extends Resource implements HasShieldPermissions
{
    protected static ?string $model = Commission::class;

    protected static ?string $cluster = WalletSystem::class;

    protected static ?string $navigationIcon = 'heroicon-o-banknotes';

    public static function getNavigationLabel(): string
    {
        return __('messages.t_earning_navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('messages.t_earning_navigation_label');
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'view_any',
            'delete_any'
        ];
    }
    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_earning');
    }
    public static function canDeleteAny(): bool
    {
        return userHasPermission('delete_any_earning');
    }
    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->columns([
                Tables\Columns\TextColumn::make('user.name')
                    ->label(__('messages.t_earning_table.user_name'))
                    ->sortable(),
                Tables\Columns\TextColumn::make('payable_type')
                    ->label(__('messages.t_earning_table.payable_type'))
                    ->formatStateUsing(fn($state) => class_basename($state))
                    ->sortable(),
                Tables\Columns\TextColumn::make('amount')
                    ->label(__('messages.t_earning_table.amount'))
                    ->sortable()
                    ->money(getCurrencySetting()),
                Tables\Columns\TextColumn::make('commission_rate')
                    ->label(__('messages.t_earning_table.commission_rate'))
                    ->sortable(),
                Tables\Columns\TextColumn::make('commission_type')
                    ->label(__('messages.t_earning_table.commission_type'))
                    ->sortable(),
                Tables\Columns\TextColumn::make('commission_amount')
                    ->label(__('messages.t_earning_table.commission_amount'))
                    ->sortable()->money(getCurrencySetting()),
                Tables\Columns\TextColumn::make('status')
                    ->label(__('messages.t_earning_table.status'))
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('messages.t_earning_table.created_at'))
                    ->date()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);;
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEarnings::route('/'),
            // 'create' => Pages\CreateEarning::route('/create'),
            // 'edit' => Pages\EditEarning::route('/{record}/edit'),
        ];
    }
}
