<?php

namespace Adfox\WalletSystem\Filament\Resources\WalletClaimResource\Pages;

use Adfox\WalletSystem\Filament\Resources\WalletClaimResource;
use Filament\Actions;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;

class ListWalletClaims extends ListRecords
{
    protected static string $resource = WalletClaimResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            __('messages.t_requested') => Tab::make()
                ->modifyQueryUsing(fn(Builder $query) => $query->where('status', 'pending')),
            __('messages.t_ap_completed') => Tab::make()
                ->modifyQueryUsing(fn(Builder $query) => $query->where('status', 'completed')),
        ];
    }
}
