<?php

namespace Adfox\WalletSystem;

use Filament\Navigation\NavigationGroup;
use Filament\Panel;
use Filament\Contracts\Plugin;

class WalletSystemPlugin implements Plugin
{
    public function getId(): string
    {
        return 'wallet-system';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\WalletSystem\\Filament\\Resources'
            )->discoverPages(
                in: __DIR__ . '/Filament/Pages',
                for: 'Adfox\\WalletSystem\\Filament\\Pages'
            )->discoverClusters(
                in: __DIR__ . '/Filament/Clusters',
                for: 'Adfox\\WalletSystem\\Filament\\Clusters'
            )->discoverWidgets(
                in: __DIR__ . '/Filament/Widgets',
                for: 'Adfox\\WalletSystem\\Filament\\Widgets'
            );
        } else if ($panel->getId() == 'app' && isWalletSystemEnabled()) {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/App/Resources',
                for: 'Adfox\\WalletSystem\\Filament\\App\\Resources'
            )->discoverPages(
                in: __DIR__ . '/Filament/App/Pages',
                for: 'Adfox\\WalletSystem\\Filament\\App\\Pages'
            )->discoverClusters(
                in: __DIR__ . '/Filament/App/Clusters',
                for: 'Adfox\\WalletSystem\\Filament\\App\\Clusters'
            )->discoverWidgets(
                in: __DIR__ . '/Filament/App/Widgets',
                for: 'Adfox\\WalletSystem\\Filament\\App\\Widgets'
            )->navigationGroups([
                NavigationGroup::make( __('messages.t_wallet_system_navigation'))->icon('heroicon-o-wallet')
            ]);
        }
    }

    public function boot(Panel $panel): void {}
}
